<?php
session_start();

include("../../include/config_animal.php");
 
// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["online_ed_pharma_admin_login"]) || $_SESSION["online_ed_pharma_admin_login"] !== true){
    header("location: ../index.php");
    exit;
}

date_default_timezone_set('Asia/Kolkata');  
$date= date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $_SESSION["online_ed_pharma_admin_page_title"];?> | Admin </title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="../assets/vendors/iconfonts/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="../assets/vendors/iconfonts/ionicons/css/ionicons.css">
    <link rel="stylesheet" href="../assets/vendors/iconfonts/typicons/src/font/typicons.css">
    <link rel="stylesheet" href="../assets/vendors/iconfonts/flag-icon-css/css/flag-icon.min.css">
    <link rel="stylesheet" href="../assets/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="../assets/vendors/css/vendor.bundle.addons.css">
    <!-- endinject -->
    <!-- plugin css for this page -->
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="../assets/css/shared/style.css">
    <!-- endinject -->
    <!-- Layout styles -->
    <link rel="stylesheet" href="../assets/css/demo_1/style.css">
    <!-- End Layout styles -->
    <link rel="shortcut icon" href="../assets/images/<?php echo $_SESSION["online_ed_pharma_admin_page_logo"];?>" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  </head>
  <body>
    <div class="container-scroller">
      
      <?php include('header.php');?>

        <div class="main-panel">
          <div class="content-wrapper">            
            <div class="row">
              <div class="col-md-8 grid-margin stretch-card">
                    <div class="card">
                      <div class="card-body">
                        <div class="row">
                          <div class="col-md-4">
                            <div class="d-flex align-items-center pb-2">
                              <div class="dot-indicator bg-primary mr-2"></div>
                              <p class="mb-0">Pending Request</p>
                            </div>
                            <h4 class="font-weight-semibold">
                                <?php
                                $sql=mysqli_query($con,"SELECT * from add_conflict WHERE status='Pending'");
                                echo mysqli_num_rows($sql);
                                ?>
                            </h4>
                            <div class="progress progress-md">
                              <div class="progress-bar bg-primary" role="progressbar" style="width: 78%" aria-valuenow="78" aria-valuemin="0" aria-valuemax="78"></div>
                            </div>
                          </div>
                          <div class="col-md-4 mt-4 mt-md-0">
                            <div class="d-flex align-items-center pb-2">
                              <div class="dot-indicator bg-success mr-2"></div>
                              <p class="mb-0">Approved Request</p>
                            </div>
                            <h4 class="font-weight-semibold">
                                <?php
                                $sql1=mysqli_query($con,"SELECT * from add_conflict WHERE status='Approved'");
                                echo mysqli_num_rows($sql1);
                                ?>
                            </h4>
                            <div class="progress progress-md">
                              <div class="progress-bar bg-success" role="progressbar" style="width: 45%" aria-valuenow="45" aria-valuemin="0" aria-valuemax="45"></div>
                            </div>
                          </div>
                          <div class="col-md-4 mt-4 mt-md-0">
                            <div class="d-flex align-items-center pb-2">
                              <div class="dot-indicator bg-danger mr-2"></div>
                              <p class="mb-0">Rejected Request</p>
                            </div>
                            <h4 class="font-weight-semibold">
                                <?php
                                $sql2=mysqli_query($con,"SELECT * from add_conflict WHERE status='Rejected'");
                                echo mysqli_num_rows($sql2);
                                ?>
                            </h4>
                            <div class="progress progress-md">
                              <div class="progress-bar bg-danger" role="progressbar" style="width: 45%" aria-valuenow="45" aria-valuemin="0" aria-valuemax="45"></div>
                            </div>
                          </div>
                          <!--<div class="col-md-3 mt-4 mt-md-0">-->
                          <!--  <div class="d-flex align-items-center pb-2">-->
                          <!--    <div class="dot-indicator bg-success mr-2"></div>-->
                          <!--    <p class="mb-0">Completed</p>-->
                          <!--  </div>-->
                          <!--  <h4 class="font-weight-semibold">36</h4>-->
                          <!--  <div class="progress progress-md">-->
                          <!--    <div class="progress-bar bg-success" role="progressbar" style="width: 45%" aria-valuenow="45" aria-valuemin="0" aria-valuemax="45"></div>-->
                          <!--  </div>-->
                          <!--</div>-->
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4 grid-margin stretch-card average-price-card">
                    <div class="card text-white">
                      <div class="card-body">
                        <div class="d-flex justify-content-between pb-2 align-items-center">
                          <h2 class="font-weight-semibold mb-0">
                              <?php
                                $sql3=mysqli_query($con,"SELECT * from add_conflict");
                                echo mysqli_num_rows($sql3);
                                ?>
                          </h2>
                          <div class="icon-holder">
                            <i class="mdi mdi-briefcase-outline"></i>
                          </div>
                        </div>
                        <div class="d-flex justify-content-between">
                          <h5 class="font-weight-semibold mb-0">Total Request</h5>
                          <p class="text-white mb-0"></p>
                        </div>
                      </div>
                    </div>
                  </div>

            </div>
            
            
            <div class="row">                        
              <div class="col-lg-12 grid-margin stretch-card">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">Recent Entries </h4>
                   
                    <table class="table table-striped">
                      <thead>
                        <tr>
                          <th> Image </th>
                          <th> Tiger Name </th>
                          <th> RFO </th>
                          <th> Guard </th>
                          <th> Date </th>
                          <th> Status </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        $sql=mysqli_query($con,"SELECT * FROM add_conflict");
                        while($row=mysqli_fetch_assoc($sql)){
                        ?>
                        <tr>
                          <td class="py-1">
                            <img src="../../API/Conflict Images/<?php echo $row['image'];?>" alt="image" /> </td>
                          <td> <?php echo $row['conflict_type'];?> </td>
                          <td> <?php echo $row['rfo_name'];?> </td>
                          <td> <?php echo $row['guard_name'];?> </td>
                          <td> <?php echo $row['date'];?> </td>
                          <td> <?php echo $row['status'];?> </td>
                        </tr>
                        <?php
                        }
                        ?>
                        
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- content-wrapper ends -->
          
          <?php include('footer.php');?>

        </div>
        <!-- main-panel ends -->
      </div>
      <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->
    <!-- plugins:js -->
    <script src="../assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="../assets/vendors/js/vendor.bundle.addons.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page-->
    <!-- End plugin js for this page-->
    <!-- inject:js -->
    <script src="../assets/js/shared/off-canvas.js"></script>
    <script src="../assets/js/shared/misc.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page-->
    <script src="../assets/js/demo_1/dashboard.js"></script>
    <!-- End custom js for this page-->
  </body>
</html>